package com.ejie.ab04b.util;

import javax.servlet.http.HttpServletRequest;

import org.springframework.ui.Model;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * Clase con utilidades para el manejo de datos almacenados en sesion
 * 
 * @author UDA
 */
public final class ManejoSesion {

	/**
	 * Instantiates a new manejo sesion.
	 */
	private ManejoSesion() {
		super();
	}

	/**
	 * Gets the datos navegacion.
	 * 
	 *  request            HttpServletRequest
	 *  DatosNavegacion
	 *
	 * @param request the request
	 * @return the datos navegacion
	 */
	public static DatosNavegacion getDatosNavegacion(HttpServletRequest request) {
		DatosNavegacion datosNavegacion = null;
		try {
			datosNavegacion = (DatosNavegacion) request.getSession()
					.getAttribute(Constantes.PARAMETRO_DATOS_NAVEGACION);
		} catch (Exception e) {
			datosNavegacion = null;
		}

		if (datosNavegacion == null) {
			datosNavegacion = new DatosNavegacion();
		}

		return datosNavegacion;
	}

	/**
	 * Sets the datos navegacion.
	 * 
	 *  request            HttpServletRequest
	 *  datosNavegacion            DatosNavegacion
	 *
	 * @param request the request
	 * @param datosNavegacion the datos navegacion
	 */
	public static void setDatosNavegacion(HttpServletRequest request,
			DatosNavegacion datosNavegacion) {
		request.getSession().setAttribute(
				Constantes.PARAMETRO_DATOS_NAVEGACION, datosNavegacion);
	}

	/**
	 * Pasa los datos de navegacion de sesion al model.
	 * 
	 *  request            HttpServletRequest
	 *  model            Model
	 *  clazz            Clazz
	 *  Object
	 *
	 * @param request the request
	 * @param model the model
	 * @param clazz the clazz
	 * @return the object
	 */
	public static Object pasaDatosNavegacionModel(HttpServletRequest request,
			Model model, Class<?> clazz) {

		Object objetoFiltro = null;

		DatosNavegacion datosNavegacion = ManejoSesion
				.getDatosNavegacion(request);
		if (datosNavegacion != null) {
			model.addAttribute("page", datosNavegacion.getPagina());
			model.addAttribute("rowNum", datosNavegacion.getRegistrosPagina());
			model.addAttribute("campoOrden", datosNavegacion.getCampoOrden());
			model.addAttribute("orden", datosNavegacion.getOrden());
		}

		// devuelve el filtro si nos pasan tipo de clase y coincide con la de
		// sesión
		if (clazz != null) {
			if (datosNavegacion.getFiltro() != null
					&& clazz.equals(datosNavegacion.getFiltro().getClass())) {
				// recuperamos filtro
				objetoFiltro = datosNavegacion.getFiltro();
			} else {
				// recuperamos instancia nueva de clase filtro
				try {
					objetoFiltro = clazz.newInstance();
				} catch (Exception e) {
					objetoFiltro = null;
				}
			}
		}

		datosNavegacion.setVolver(true);
		ManejoSesion.setDatosNavegacion(request, datosNavegacion);

		return objetoFiltro;
	}

	/**
	 * Sets the datos sesion.
	 * 
	 *  request            HttpServletRequest
	 *  objetoSesionNombre            String
	 *  objetoSesionValor            Object
	 *
	 * @param request the request
	 * @param objetoSesionNombre the objeto sesion nombre
	 * @param objetoSesionValor the objeto sesion valor
	 */
	public static void setDatosSesion(HttpServletRequest request,
			String objetoSesionNombre, Object objetoSesionValor) {

		request.getSession()
				.setAttribute(objetoSesionNombre, objetoSesionValor);

	}

	/**
	 * Gets the parametro accion.
	 * 
	 *  request            HttpServletRequest
	 *  String
	 *
	 * @param request the request
	 * @return the parametro accion
	 */
	public static String getParametroAccion(HttpServletRequest request) {
		String accion = null;
		try {
			accion = (String) request.getSession().getAttribute(
					Constantes.PARAMETRO_ACCION);
		} catch (Exception e) {
			accion = null;
		}
		return accion;
	}

	/**
	 * Checks if is volver.
	 * 
	 *  request            HttpServletRequest
	 *  boolean
	 *
	 * @param request the request
	 * @return true, if is volver
	 */
	public static boolean isVolver(HttpServletRequest request) {
		DatosNavegacion datosNavegacion = getDatosNavegacion(request);
		if (datosNavegacion != null) {
			return datosNavegacion.isVolver();
		}
		return false;
	}

	/**
	 * Recupera datos filtro.
	 * 
	 *  request            HttpServletRequest
	 *  jqGridRequestDto            JQGridRequestDto
	 *  clazz            Clazz
	 *  Object
	 *
	 * @param request the request
	 * @param jqGridRequestDto the jq grid request dto
	 * @param clazz the clazz
	 * @return the object
	 */
	public static Object recuperaDatosFiltro(HttpServletRequest request,
			JQGridRequestDto jqGridRequestDto, Class<?> clazz) {

		Object datosFiltro = null;
		DatosNavegacion datosNavegacion = ManejoSesion
				.getDatosNavegacion(request);
		// si estamos en accion volver recupera filtro guardado en sesion
		if (datosNavegacion.isVolver()) {
			if (datosNavegacion.getFiltro() != null
					&& clazz.equals(datosNavegacion.getFiltro().getClass())) {
				jqGridRequestDto.setPage(Long.valueOf(datosNavegacion
						.getPagina()));
				jqGridRequestDto.setSidx(datosNavegacion.getCampoOrden());
				jqGridRequestDto.setSord(datosNavegacion.getOrden());
				datosFiltro = datosNavegacion.getFiltro();
			}
			datosNavegacion.setVolver(false);
			ManejoSesion.setDatosNavegacion(request, datosNavegacion);
		}

		return datosFiltro;

	}

	/**
	 * Guarda filtro.
	 * 
	 *  request            HttpServletRequest
	 *  filtro            Object
	 *  jqGridRequestDto            JQGridRequestDto
	 *
	 * @param request the request
	 * @param filtro the filtro
	 * @param jqGridRequestDto the jq grid request dto
	 */
	public static void guardaFiltro(HttpServletRequest request, Object filtro,
			JQGridRequestDto jqGridRequestDto) {

		DatosNavegacion datosNavegacion = (DatosNavegacion) ManejoSesion
				.getDatosNavegacion(request);
		datosNavegacion.setPagina(jqGridRequestDto.getPage().toString());
		datosNavegacion.setRegistrosPagina(jqGridRequestDto.getRows()
				.toString());
		datosNavegacion.setCampoOrden(jqGridRequestDto.getSidx());
		datosNavegacion.setOrden(jqGridRequestDto.getSord());
		datosNavegacion.setFiltro(filtro);

		ManejoSesion.setDatosNavegacion(request, datosNavegacion);
	}

	/**
	 * reset filtro.
	 * 
	 *  request            HttpServletRequest
	 *  filtro            Object
	 *
	 * @param request the request
	 * @param filtro the filtro
	 */
	public static void resetFiltro(HttpServletRequest request, Object filtro) {
		DatosNavegacion datosNavegacion = (DatosNavegacion) ManejoSesion
				.getDatosNavegacion(request);
		datosNavegacion.resetDatosGrid();
		datosNavegacion.setFiltro(filtro);
		datosNavegacion.setVolver(false);
		ManejoSesion.setDatosNavegacion(request, datosNavegacion);
	}
}
